require( "scripts/style.lua" );


MyFont = {
  standardFont,
  22,
  BorderColor
};

NameFont = {
  standardFont,
  18,
  BorderColor
};

kImageY = 5;
kButtonX = 10;
kButtonY = 5;
kButtonSpacing = 28;
kTextX = 0;
kTextY = 5;

kHeaderY = 100;
kLevelX = 100;
kRatingX = 300;
kStatusX = 500;

HeaderFont = {
	standardFont,
	24,
	BorderColor
};

EntryFont = {
	standardFont,
	14,
	BorderColor
};

SlotButtonGraphics = {
	"scripts/leveleditor/customer_a",
	"scripts/leveleditor/customer_b",
	"scripts/leveleditor/customer_c"
};


function GameSlot(n)
	return Group {

			
		Button
		{
			name = 'gamebutton_'..n,
			x = kButtonX, y = kButtonY+kButtonSpacing*(n-1),
			graphics=SlotButtonGraphics,
			font = EntryFont,
			label = '',
			command =
				function()
					SetLevelName(n-1);
				end
		},
	}
end

function GameSlots()
	t= {}
	for i = 1,5 do
		table.insert(t,GameSlot(i))
	end
	return Group(t)
end







MakeDialog
{
	Bitmap
	{ 
		image="backgrounds/longdialog",
		x=kCenter,
		y=kCenter,
		
		EnterNameWindow
		{
			x=0,y=0,w=kMax,h=kMax,
			
			
			Text
			{
				font = MyFont,
				name = "levelpack",
				x=0,y=20,w=kMax,h=30,
				flags = kHAlignCenter + kVAlignTop,
				label = "le_levelpack"
			};
			
			Button
			{
				graphics = LeftArrowGraphics,
				name = 'restaurantleft',
				x = 50,
				y = 60,
				command=
					function()
						IncrementLevelPack( -1 );
					end
			},
			
			
			Text
			{
				x=kCenter,y=50,
				w=190,h=60,
				font=MyFont,
				flags = kHAlignCenter+kVAlignCenter,
				name = 'levelpack',
				label='#'..GetCurrentLevelPack();
				
			},
			
			Button
			{
				graphics = LeftArrowGraphics,
						hflip = true,
				name = 'restaurantright',
				x = 300,
				y = 60,
				command=
					function()
						IncrementLevelPack( 1 );
					end
			},
			Text
			{
				font = MyFont,
				name = "entername",
				x=0,y=120,w=kMax,h=30,
				flags = kHAlignCenter + kVAlignTop,
				label = "le_entername"
			};
			
			SetStyle(ScrolledWindowStyle);
			
			LevelNameWindow
			{
				name = "gamescroller",
				x = 50,
				y = 160,
				w = 280,
				h = 150,
				SetStyle(DefaultStyle);
				GameSlots(),
			},
			
			Bitmap
			{
				image="backgrounds/textfield.png",
				x=kCenter,
				y=325,
				
				TextEdit
				{
					font = NameFont,
					name = "nameedit",
					label = playername,
					x=5,y=6,w=kMax-5,h=kMax,
					length=50,
					ignore = kIllegalNameChars
					
				};
			};
				
			SetStyle(StandardButtonStyle);
			Button
			{
				x=kCenter,
				y=375,
				name="enterok",
				label="ok",
				default = true,
				command = 
					function()
						if (GetCurrentLevelPackRestaurant() == '') then
							CloseWindow(GetCurrentLevelPack().."/mplevels/"..GetCurrentLevelPack().."/"..GetLabel("nameedit"));
						else
							CloseWindow(GetCurrentLevelPack().."/restaurants/"..GetCurrentLevelPackRestaurant().."/mplevels/"..GetLabel("nameedit"));
						end
					end
			},
			
			Button
			{
				x=kCenter,
				y=425,
				name="entercancel",
				label="cancel",
				command = 
					function()
						CloseWindow(nil);
					end
			};
			SetStyle(DefaultStyle);
		}
		
	},
	
	SetFocus( "nameedit" )
}



